/* FILE: mdemux.h                               (D. Tottingham  03/24/91)

This is an include file of defines, data structure definitions and
external declarations that are common in the mdemux module.

*/

#ifndef _MDEMUX_
#define _MDEMUX_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define PRE_EVENT_TIME                  11      /* 11 seconds */

#define NEW_BUFFER                      3
#define AVAILABLE_BUFFER                2
#define ARCHIVED_BUFFER                 1


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC double dm_get_current_time ();
PUBLIC Q_BUFFER far * dm_get_first_buffer ();
PUBLIC Q_BUFFER far * dm_get_head_buffer ();
PUBLIC void dm_get_new_buffers ();
PUBLIC Q_BUFFER far * dm_get_next_buffer ();
PUBLIC double dm_get_pre_event_time ();
PUBLIC Q_BUFFER far * dm_get_tail_buffer ();
PUBLIC double dm_get_uptime ();
PUBLIC void dm_initialize ();
PUBLIC void dm_initialize_params ();
PUBLIC void dm_initialize_time ();
PUBLIC void dm_reset ();
PUBLIC void dm_set_PreEventTime (double);

#endif
